unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OmegaTimer, OmegaFont, OmegaInput, OmegaImageList, OmegaScreen,
  OmegaSprite;

type

  //*********Wtek adowania gry**********************
  TWatekLadowania=class(TTHread)
   public
    _plikGry:string;
    procedure OdczytGry(plikGry:string);
   protected
    constructor Create(flaga:boolean;plikGry:string);
    procedure Execute;override;
  end;

  TForm1 = class(TForm)
    OmegaScreen1: TOmegaScreen;
    OmegaImageList1: TOmegaImageList;
    OmegaInput1: TOmegaInput;
    OmegaFont1: TOmegaFont;
    OmegaTimer1: TOmegaTimer;
    OmegaSprite1: TOmegaSprite;
    OmegaImageList2: TOmegaImageList;
    procedure OmegaTimer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }

    procedure LogoLadowaniaGry;
    procedure CzysteMapy;
    procedure RuchWSwiecie(Predkosc:real);
    procedure RuchWSwiecieWzgledemBohatera(aSkokX,aSkokY:real);
    procedure OdczytPlikuMapySwiata(AStringList:TStringList;var fZaladowanoPlik:boolean);
    procedure OdswiezEkran;
    procedure LAdujOIL(OILNAme:string);
  public
    { Public declarations }
  end;
  function GetSubstring(var inStr:string;const separator:string):string;
var

  fZaladowanoPlik:boolean=false;
  WatekLadowania:TWatekLadowania;
  a,b:byte;
  Form1: TForm1;

implementation
uses UnitWarstwy, UnitPanel,pierwotniak, praduszek, UnitCyklSwiata;
{$R *.DFM}
//Watek ladowania
constructor TWatekLadowania.Create(flaga:boolean;plikGry:string);
begin
 inherited Create(flaga);
 _plikGry:=plikGry;
end;
procedure TWatekLadowania.OdczytGry(plikGry:string);
var
 stringList:TStringList;
begin
  StringList:=TStringList.Create;
  stringList.LoadFromFile(plikGry);
  Form1.OdczytPlikuMapySwiata(stringList,fZaladowanoPlik);
  RobPierwotniaka(Form1.OmegaSprite1,Form1.OmegaImageList1,Form1.OmegaInput1,'pierwotny000',1,200,300);
  StringList.Free;
  Form1.OdswiezEkran;
end;

 procedure TWatekLadowania.Execute;
 begin
  FreeOnTerminate:=true;
  if Terminated then exit;
  OdczytGry(_plikGry);
 end;
//******************************************
//TOSTERA odczyt i skracanie ancucha
function GetSubstring(var inStr:string;const separator:string):string;
var
  t: integer;
begin
  t := Pos(separator, inStr);
  if t <=0 then t := Length(inStr)+1;
  Result := Copy(inStr, 1, t-1);
  inStr := Copy(inStr, t+1, Length(inStr));
end ;
procedure TForm1.LogoLadowaniaGry;
const
  k:single=0;
begin
 OmegaFont1.Print(OmegaScreen1.Width div 2,OmegaScreen1.Height div 2,'Czekaj...');
 k:=k+10*OmegaTimer1.DeltaSecs;
 OmegaScreen1.DrawRectangle(200,260,round(200+k),262,true,1,0,255,0);
 if k>OmegaScreen1.Width-200  then k:=0;
end;

procedure TForm1.RuchWSwiecie(Predkosc:real);
begin

 if oisLeft  in OmegaInput1.Keyboard.States then SkokX:=Predkosc;
 if oisRight in OmegaInput1.Keyboard.States then SkokX:=-Predkosc;
 if oisDown  in OmegaInput1.Keyboard.States then SkokY:=-Predkosc;
 if oisUp    in OmegaInput1.Keyboard.States then SkokY:=Predkosc;

 RogSwiata.x:=RogSwiata.x+skokX;
 RogSwiata.y:=RogSwiata.y+skokY;

 RogSwiata.kolumna:=-Round(rogSwiata.x) div DaneMapy.W1Kosc;
 RogSwiata.wiersz :=-Round(rogSwiata.y) div DaneMapy.H1Kosc;
 RogSwiata.Indeks:=(RogSwiata.kolumna + RogSwiata.wiersz*DaneMapy.XCount);

end;
procedure TForm1.RuchWSwiecieWzgledemBohatera(aSkokX,aSkokY:real);
begin
  skokX:=-AskokX;
  skokY:=-AskokY;
  RogSwiata.x:=RogSwiata.x+skokX;
  RogSwiata.y:=RogSwiata.y+skokY;

  RogSwiata.kolumna:=-Round(rogSwiata.x) div DaneMapy.W1Kosc;
  RogSwiata.wiersz :=-Round(rogSwiata.y) div DaneMapy.H1Kosc;
  RogSwiata.Indeks:=(RogSwiata.kolumna + RogSwiata.wiersz*DaneMapy.XCount);
end;

procedure TForm1.OmegaTimer1Timer(Sender: TObject);
var
 x:integer;
begin
 Cykl.deltaSeconds:=OmegaTimer1.DeltaSecs;
 OmegaInput1.Update;
 if oisbutton28 in OmegaInput1.keyboard.statesclicked then
  OmegaScreen1.ToggleFullScreen;
 if not omegascreen1.CanDraw then exit;

 OmegaScreen1.BeginRender;
 OmegaScreen1.ClearScreen(0,0,0,0);
 if fZaladowanoPlik then
 begin
  Cykl.Animacja;
  TPierwotny(PraLista.Items[idAktywnyDuszek]).Klawiszologia;

  RuchWSwiecieWzgledemBohatera(TPierwotny(PraLista.Items[idAktywnyDuszek]).skokX,TPierwotny(PraLista.Items[idAktywnyDuszek]).skokY);

  PokazGrunt(skokX,skokY);
  TPierwotny(PraLista.Items[idAktywnyDuszek]).skokX:=0;
  TPierwotny(PraLista.Items[idAktywnyDuszek]).skokY:=0;

  //dotyczy warstwy 1, 2
  OmegaSprite1.Collision;
  OmegaSprite1.Dead;
  OmegaSprite1.Move(OmegaTimer1.DeltaSecs);
  OmegaSprite1.Draw;

  //koniec dotyczy warstw 1 i 2
  skokX:=0;
  skokY:=0;
  DrawPanele(OmegaImageList2, OmegaScreen1);
  x:=round(OmegaScreen1.width*0.86);
  OmegaFont1.Print(x,10, 'F2 zmiana trybu wywietlania aplikacji');
  OmegaFont1.Print(x,30,'FPS: '+IntToStr(OmegaTimer1.FPS));
  OmegaFont1.Print(x,50,'Rozmiar w pikselach:');
  OmegaFont1.Print(x,70,PChar(Format('%d x %d',[DAneMapy.xCount*DaneMapy.W1Kosc,DAneMapy.YCount*DaneMapy.H1Kosc])));

 end else LogoLadowaniaGry;
 OmegaScreen1.EndRender;
end;

procedure TForm1.CzysteMapy;
var
  AMapa:PMapa;
  a,b,
  i:LongInt;

begin

  if Lista.Count>1 then
  for i:=0 to Lista.Count-1 do
  Dispose(PMapa(Lista.Items[i]));
  Lista.Clear;
  //czysta mapa Gruntu
  New(AMapa);
  Lista.Add(AMapa);
  TworzMApeWarstwy(0,DaneMApy.XCount,DaneMapy.YCount, -1,AMapa);//zaruj aby rysowana byla siatka- klatka puste
  //czysta mapa warstwy pierwszej
  New(AMapa);
  Lista.Add(AMapa);
  TworzMApeWarstwy(0,DaneMApy.XCount,DaneMapy.YCount, -1,AMapa);//-1 aby nic nie bylo rysowane
  //czysta mapa warstwy drugiej
  New(AMapa);
  Lista.Add(AMapa);
  TworzMApeWarstwy(0,DaneMApy.XCount,DaneMapy.YCount, -1,AMapa);//-1 aby nic nie bylo rysowane
  //Czyste warswty

  ZerujTabliceDynamicznaWarstw;
  for b:=0 to DaneMapy.YSwiataEkranu-1 do
   for a:=0 to DAneMapy.XSwiataEkranu-1 do
   begin
     //warstwa ZERO- nowy pomys
      SwiatProstokatnyGrunt[a,b]:=TKostkaGruntuMapy.Kreacja(
                               DAneMapy,
                               0,0,0,a,b);
     //warstwa 1
      SwiatProstokatnyWarstwy[1,a,b]:=TKostkaMapy.Kreacja(DaneMapy.OmegaSprite,
                          DAneMapy,
                          0,0,1,a,b,b{czyli z});

     //warstwa 2- Mona z tej warstwy zrezygnowa, gadet moze by wiwietlany
     // w drugim obrazie warstwy pierwszej,
     //jeeli usuniesz t linijk kodu to misisz usunc lini
     // SwiatProstokatnyWarstwy[2,a,b].ZmianaKlatki; w procedurze OdswiezEkran
    {  SwiatProstokatnyWarstwy[2,a,b]:=TKostkaMapy.Kreacja(DaneMapy.OmegaSprite,
                          DAneMapy,
                          0,0,2,a,b,b+3);}
   end;

end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Randomize;
  skokX:=0;
  skokY:=0;
  Lista:=Tlist.Create;
  PraLista:=TList.Create;
  //
  Cykl:=TCykl.Create;
  Cykl.fLista:=TList.Create;
  OmegaScreen1.Init;
  OmegaScreen1.SetHWnd(self.handle);
  OmegaFont1.Init;
  OmegaFont1.CreateFont('Arial',10,[]);
  OmegaFont1.Color:=OmegaColor(255,200,0);
  //
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var
  i:longWord;
begin
  OmegaTimer1.Enabled:=false;
  OmegaSprite1.Dead;
  OmegaScreen1.FreeOnRelease;
  if Lista.Count>1 then
  for i:=0 to Lista.Count-1 do Dispose(PMapa(Lista.Items[i]));
  Lista.Free;
  if OmegaScreen1.FullScreen then  OmegaScreen1.ToggleFullScreen;
  PraLista.free;
  Cykl.Destroy;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
 OmegaTimer1.Enabled:=true;
 WatekLadowania:=TWatekLadowania.Create(false,'swiat_512x384.mue2D');
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key= 27 then close;
end;

procedure TForm1.LAdujOIL(OILNAme:string);
var
 tempOmegaImageList:TOmegaImageList;
 picture:TPicture;
 i:integer;
begin
 tempOmegaImageList:=TOmegaImageList.Create(nil);
 tempOmegaImageList.ImageList.LoadFromFile(OILNAme);

 picture:=tpicture.Create;
 for i:=0 to tempOmegaImageList.ImageList.Count-1 do begin
     picture.Assign(tempOmegaImageList.ImageList.Items[i].Picture);
     OmegaImageList1.ImageList.Add;
     OmegaImageList1.ImageList.Items[OmegaImageList1.ImageList.Count-1].SetPicture(picture);
     OmegaImageList1.ImageList.Items[OmegaImageList1.ImageList.Count-1].Name:=tempOmegaImageList.ImageList.Items[i].Name;
     OmegaImageList1.ImageList.items[OmegaImageList1.Imagelist.count-1].DisplayName :=tempOmegaImageList.ImageList.Items[i].DisplayNAme;
     OmegaImageList1.ImageList.Items[OmegaImageList1.ImageList.Count-1].Picture.Assign(picture);
     OmegaImageList1.ImageList.Items[OmegaImageList1.ImageList.Count-1].TileWidth:=tempOmegaImageList.ImageList.Items[i].TileWidth;
     OmegaImageList1.ImageList.Items[OmegaImageList1.ImageList.Count-1].TileHeight:=tempOmegaImageList.ImageList.Items[i].TileHeight;
     OmegaImageList1.ImageList.Items[OmegaImageList1.ImageList.Count-1].Transparent:=tempOmegaImageList.ImageList.Items[i].Transparent;
     OmegaImageList1.ImageList.Items[OmegaImageList1.ImageList.Count-1].TransparentColor:=tempOmegaImageList.ImageList.Items[i].TransparentColor;
     OmegaImageList1.ImageList.Items[OmegaImageList1.ImageList.Count-1].Init;
 end;
 picture.free;
 tempOmegaImageList.Free;

end;

procedure TForm1.OdczytPlikuMapySwiata(AStringList:TStringList;var fZaladowanoPlik:boolean);
var
 L,P,
 i,iloczyn_KxW:LongWord;
 s:string;
 j,ile_oil:integer;
 procedure PrzypiszDeneDoWarstwProstokatnych(const aI,aITekst:longWord);
 begin
  s:=AStringList.Strings[aITekst];
  while Length(s)>0 do begin
     PMapa(Lista.Items[0])^[aI].Name:=GetSubstring(s,' ');//1
     PMapa(Lista.Items[0])^[aI].idKlatka:=StrToInt(GetSubstring(s,' '));//2
     PMapa(Lista.Items[0])^[aI].left:=StrToInt(GetSubstring(s,' '));//3
     PMapa(Lista.Items[0])^[aI].top:=StrToInt(GetSubstring(s,' '));//4
     PMapa(Lista.Items[0])^[aI].RGBA.R:=StrToInt(GetSubstring(s,' '));//5
     PMapa(Lista.Items[0])^[aI].RGBA.G:=StrToInt(GetSubstring(s,' '));//6
     PMapa(Lista.Items[0])^[aI].RGBA.B:=StrToInt(GetSubstring(s,' '));//7
     PMapa(Lista.Items[0])^[aI].RGBA.A:=StrToInt(GetSubstring(s,' '));//8
     PMapa(Lista.Items[0])^[aI].RGBA.idKlatka2:=StrToInt(GetSubstring(s,' '));//9
     PMapa(Lista.Items[0])^[aI].RGBA.AlphaA:=StrToInt(GetSubstring(s,' '));//10
     PMapa(Lista.Items[0])^[aI].RGBA.AlphaB:=StrToInt(GetSubstring(s,' '));//11
     PMapa(Lista.Items[0])^[aI].RGBA.AlphaC:=StrToInt(GetSubstring(s,' '));//12
     PMapa(Lista.Items[0])^[aI].RGBA.AlphaD:=StrToInt(GetSubstring(s,' '));//13
     //PIERWSZA
     PMapa(Lista.Items[1])^[aI].Name:=GetSubstring(s,' ');//14
     PMapa(Lista.Items[1])^[aI].idKlatka:=StrToInt(GetSubstring(s,' '));//15
     PMapa(Lista.Items[1])^[aI].left:=StrToInt(GetSubstring(s,' '));//16
     PMapa(Lista.Items[1])^[aI].top:=StrToInt(GetSubstring(s,' '));//17
     PMapa(Lista.Items[1])^[aI].RGBA.zakazWstepu:=StrToInt(GetSubstring(s,' '));//18

     //DRUGA
     PMapa(Lista.Items[2])^[aI].Name:=GetSubstring(s,' ');//19
     PMapa(Lista.Items[2])^[aI].idKlatka:=StrToInt(GetSubstring(s,' '));//20
     PMapa(Lista.Items[2])^[aI].left:=StrToInt(GetSubstring(s,' '));//21
     PMapa(Lista.Items[2])^[aI].top:=StrToInt(GetSubstring(s,' '));//22
     //Podmie klatki w pynnych przejciach gdy wszystkie rogi maj 255
     if PMapa(Lista.Items[0])^[aI].RGBA.AlphaA+
        PMapa(Lista.Items[0])^[aI].RGBA.AlphaB+
        PMapa(Lista.Items[0])^[aI].RGBA.AlphaC+
        PMapa(Lista.Items[0])^[aI].RGBA.AlphaD=1020 then
        begin
         PMapa(Lista.Items[0])^[aI].idKlatka:=PMapa(Lista.Items[0])^[aI].RGBA.idKlatka2;
         PMapa(Lista.Items[0])^[aI].RGBA.idKlatka2:=-1;
        end;
     PMapa(Lista.Items[0])^[aI].idObrazka:=OmegaImageList1.ImageList.Find(PMapa(Lista.Items[0])^[aI].Name).ID;

     //PIERWSZA
     PMapa(Lista.Items[1])^[aI].idObrazka:=OmegaImageList1.ImageList.Find(PMapa(Lista.Items[1])^[aI].Name).ID;
     PMapa(Lista.Items[1])^[aI].RGBA.R:=PMapa(Lista.Items[0])^[aI].RGBA.R;//StrToInt(GetSubstring(s,' '));
     PMapa(Lista.Items[1])^[aI].RGBA.G:=PMapa(Lista.Items[0])^[aI].RGBA.G;//StrToInt(GetSubstring(s,' '));
     PMapa(Lista.Items[1])^[aI].RGBA.B:=PMapa(Lista.Items[0])^[aI].RGBA.B;//StrToInt(GetSubstring(s,' '));
     PMapa(Lista.Items[1])^[aI].RGBA.A:=PMapa(Lista.Items[0])^[aI].RGBA.A;//StrToInt(GetSubstring(s,' '));
     //DRUGA
     PMapa(Lista.Items[2])^[aI].idObrazka:=OmegaImageList1.ImageList.Find(PMapa(Lista.Items[2])^[aI].Name).ID;
     PMapa(Lista.Items[2])^[aI].RGBA.R:=PMapa(Lista.Items[0])^[aI].RGBA.R;//StrToInt(GetSubstring(s,' '));
     PMapa(Lista.Items[2])^[aI].RGBA.G:=PMapa(Lista.Items[0])^[aI].RGBA.G;//StrToInt(GetSubstring(s,' '));
     PMapa(Lista.Items[2])^[aI].RGBA.B:=PMapa(Lista.Items[0])^[aI].RGBA.B;//StrToInt(GetSubstring(s,' '));
     PMapa(Lista.Items[2])^[aI].RGBA.A:=PMapa(Lista.Items[0])^[aI].RGBA.A;//StrToInt(GetSubstring(s,' '));

     UstawAnimacjeWKaflu(PMapa(Lista.Items[0])^[aI]);//animacja Wody
     UstawAnimacjeWKaflu(PMapa(Lista.Items[1])^[aI]);//animacja Wiatrak, Myn, stany kolizji
     UstawAnimacjeWKaflu(PMapa(Lista.Items[2])^[aI]);//animacja Wiatrak, Myn, stany kolizji
  end;
 end;
begin
 i:=0;
 //czytaj nagowek
 s:=AStringList.Strings[i];inc(i);
 while Length(s)>0 do begin
  DaneMapy.typ:=TTypSwiata(Ord(StrToInt(GetSubstring(s,' '))));
  ile_oil:=StrToInt(GetSubstring(s,' '));//ile oil
  DaneMapy.W1Kosc:=StrToInt(GetSubstring(s,' '));//szerokosc kosci
  DaneMapy.H1Kosc:=StrToInt(GetSubstring(s,' '));//wzsokosc kosci
  DAneMapy.XCount:=StrToInt(GetSubstring(s,' '));//ile kolumn
  DAneMapy.YCount:=StrToInt(GetSubstring(s,' '));//ile wierszy
  DaneMapy.W1polKosc:=DaneMapy.W1Kosc div 2;
  DaneMapy.H1polKosc:=DaneMapy.H1Kosc div 2;
  iloczyn_KxW    :=StrToInt(GetSubstring(s,' '));//iloczyn kolumn i wierszy
 end;
  DaneMapy.XSwiataEkranu:=OmegaScreen1.Width  div DaneMapy.W1Kosc+1;//+2;
  DaneMapy.YSwiataEkranu:=OmegaScreen1.Height div DaneMapy.H1Kosc+2;// +2;
  DaneMapy.OmegaSprite   :=OmegaSprite1;
  DaneMapy.OmegaImageList:=OmegaImageList1;
  skokX:=0;
  skokY:=0;
  RogSwiata.x:=-DaneMapy.W1Kosc;//przesun w lewo
  RogSwiata.y:=-DaneMapy.H1Kosc;//i w gre
  RogSwiata.kolumna:=0;
  RogSwiata.wiersz:=0;
 //usu stare zasoby plikw *.oil
 if OmegaImageList1.ImageList.Count>1 then
 for j:=OmegaImageList1.ImageList.Count-1 downto 1 do
     OmegaImageList1.ImageList.Delete(j);
 //aduj nowa lite plikw oil
 for j:=i to i+ile_oil-1 do LAdujOIL(AStringList.Strings[j]);
 inc(i,ile_oil);
 //rozpocznij budowe pustych plikow map
 CzysteMapy;
 //wypenij kosci map warstw na podstawie danych z odczytanego pliku
  L:=0;P:=iloczyn_KxW-1;
  while L<=P do begin
   PrzypiszDeneDoWarstwProstokatnych(L,L+i);
   PrzypiszDeneDoWarstwProstokatnych(P,P+i);
   Cykl.Dodaj(PMapa(Lista.Items[0])^[L],0,L);
   Cykl.Dodaj(PMapa(Lista.Items[0])^[P],0,P);
   Cykl.Dodaj(PMapa(Lista.Items[1])^[L],1,L);
   Cykl.Dodaj(PMapa(Lista.Items[1])^[P],1,P);
   inc(L);
   dec(P);
  end;
  fZaladowanoPlik:=true;
end;

procedure TForm1.OdswiezEkran;
var
  a,b:byte;
begin
     //odswiez ekran
     for b:=0 to DaneMapy.YSwiataEkranu-1 do
         for a:=0 to DAneMapy.XSwiataEkranu-1 do
             begin
              SwiatProstokatnyGrunt[a,b].ZmianaKlatki;
              SwiatProstokatnyWarstwy[1,a,b].ZmianaKlatki;
              //SwiatProstokatnyWarstwy[2,a,b].ZmianaKlatki;
            end;
end;

end.
