unit praduszek;

interface
uses OmegaImageList, OmegaScreen, OmegaSprite,OmegaInput,UnitWarstwy, classes;
const
  tabWersor:array[0..7,0..1]of shortInt=(
                                        (0,-1),(1,-1),(1,0),(1,1),(0,1),(-1,1),(-1,0),(-1,-1)
                                        );

type
  tStan=(stStop,stPauza,stIdz,stBieg,stMow,stOkrzyk,stAtak,stSmierc);
  tKierunek=(k_N,k_NE,k_E,k_SE,k_S,k_SW,k_W,k_NW);

  TPraduch=class(TSprite)
  private
    fidKafla,
    fKolumna,
    fWiersz:longWord;
    fdV,         //wspczynnik predkosci
    fSkokX,      //przekazywane do skoku swiata
    fSkokY:single;
    fDeltaSeconds:single;
    fWybrany,
    fAktywny:boolean;
    fStan:tStan;
    fTabZachowan0,     //id wiersza tablicy zachowan -poczatek i koniec
    fTabZachowanK:integer;
    fKierunek:tKierunek;
    fIdObraz:integer;
    fOmegaImageList:TOmegaImageList;
  protected

    constructor Create(const AParent: TOmegaSprite;
                       const AOmegaImageList: TOmegaImageList;
                       const ANazwaObrazu:string;
                       const AIdKlatka:Integer
                       );virtual;
    procedure Move(const MoveCount:single);override;
    procedure ZmienObraz (const Value:string);virtual;
    procedure Zachowanie;virtual;
    procedure Pozycja(const aX,aY:single;const ADW,ADH:integer);

   public
    fOmegaInput    :TOmegaInput;
    function KoniecSwiata(const aX,aY:single):boolean;virtual;
    procedure Klawiszologia;virtual;
    procedure UstawKierunek(const Value:shortInt);virtual;
    property idKafla:LongWord read fidKafla write fidKafla;
    property Kolumna:LongWord read fKolumna write fKolumna;
    property Wiersz:LongWord read fWiersz write fWiersz;
    property dV:single read fdV write fdV;
    property SkokX:single read fSkokX write fSkokX;
    property SkokY:single read fSkokY write fSkokY;
    property DeltaSeconds:single read fDeltaSeconds write fDeltaSeconds;
    property Wybrany:boolean read fWybrany write fWybrany;
    property Aktywny:boolean read fAktywny write fAktywny;
    property Kierunek:tKierunek read fKierunek write fKierunek;
    property Stan:tStan read fStan write fStan;
    property TabZachowan0:integer read fTabZachowan0 write fTabZachowan0;
    property TabZachowanK:integer read fTabZachowanK write fTabZachowanK;
  end;
var
 idAktywnyDuszek:integer;
 PraLista:TList;
implementation
 function TPraduch.KoniecSwiata(const aX,aY:single):boolean;
 var
   k,w:LongInt;
 begin
   result:=false;
   k :=Round(ax-RogSwiata.x+Image.TileWidth div 2)div DaneMApy.W1Kosc;
   w :=Round(ay-RogSwiata.y+Image.TileHeight-16)div DaneMApy.H1Kosc;
   if (k<=0)or(k>=DaneMapy.xCount-1)or
      (w<=0)or(w>=DaneMapy.yCount-1)then result:=true;
 end;
 procedure TPraduch.Klawiszologia;
 begin
  if oisRight in fOmegaInput.keyboard.StatesClicked    then//obrt w prawo
     UstawKierunek(1);
  if oisLeft in fOmegaInput.keyboard.StatesClicked    then//obrt w lewo
     UstawKierunek(-1);
 end;
 procedure TPraduch.UstawKierunek(const Value:shortInt);
 var
  k:shortInt;
 begin
  k:=ord(fkierunek)+Value;
  if k<0 then k:=7;
  if k>7 then k:=0;
  ImageIndex:=k;
  fKierunek:=tKierunek(Ord(k));
 end;
 procedure TPraduch.Zachowanie;
 begin
  if ImageIndex>fTabZachowanK then ImageIndex:=fTabZachowan0;
  if ImageIndex<fTabZachowan0 then ImageIndex:=fTabZachowanK;
 end;
 procedure TPraduch.ZmienObraz(const Value:string);
 begin
  if Image.Name=Value then exit;
  Image:=fOmegaImageList.ImageList.Find(Value);
  fIdObraz:=Image.ID;
 end;
 procedure TPraduch.Pozycja(const aX,aY:single;const ADW,ADH:integer);
 var
   k,w:integer;
 begin
   fkolumna:=Round(ax-RogSwiata.x+Image.TileWidth div 2)div ADW;
   fWiersz :=Round(ay-RogSwiata.y+Image.TileHeight-16)div ADH;
   fidKafla:=fKolumna+fWiersz*DaneMApy.XCount;
   k:=Round(ax+Image.TileWidth div 2)div ADW;
   w:=Round(ay+Image.TileHeight-16)div ADH;
   z:=SwiatProstokatnyWarstwy[1,k,w].z+1;
 end;
 procedure TPraduch.Move(const MoveCount:single);
 begin
  DeltaSeconds:=MoveCount;
  inherited Move(MoveCount);
  Pozycja(x,y,DaneMApy.W1Kosc,DAneMapy.H1Kosc);
 end;
 constructor TPraduch.Create(const AParent: TOmegaSprite;
                             const AOmegaImageList: TOmegaImageList;
                             const ANazwaObrazu:string;
                             const AIdKlatka:Integer
                             );
 begin
 inherited Create(AParent);
 fOmegaImageList:=AOmegaImageList;
 Image:=fOmegaImageList.ImageList.Find(ANazwaObrazu);
 ImageIndex:=0;
 fIdObraz:=Image.ID;
 width        :=Image.TileWidth;
 height       :=Image.TileHeight;
 DoCollision  :=true;
 DoPixelCheck :=true;
end;
end.
