unit UnitCyklSwiata;

interface
uses classes,UnitWarstwy,unit1;
type
 tObiektyAnimacji=(oBrak,oWoda,oWoda1,oZboze,oWiatrakS,oWiatrakSW,oWiatrakSE,oMlynS,oMlynSW,oMlynSE,
                   oKasztan1);
 tDaneAnimacji=record
                fN             :string[12];//nazwaobrazu animowanego w drugim kaflu
                fAnimacja1,               //czy animacja w kaflu
                fAnimacja2:boolean;//czy animowac drugi obraz w kaflu
                fdV1,
                fdV2      :single; //wspoczynnik predkoci animacji

                L1,
                P1,
                L2,
                P2               :integer;//granica lewa i prawa animowanych klatek pobieranych z OmegaImageList
                fKolizja        //flaga kolizji z warstwie
                            :boolean;
               end;
const
 DaneObiektu:array [0..10]of tDaneAnimacji=(
                      (fAnimacja1:false;fAnimacja2:false)  ,//oBrak
                      (fAnimacja1:true;fdV1:2 ;L1:4 ;P1:12),//oWoda
                      (fAnimacja2:true;fdV2:2 ;L2:4 ;P2:12),//oWoda1
                      (fAnimacja1:true;fdV1:45;L1:0 ;P1:11),//oZboze1
                      (fN:'lopatyS';fAnimacja1:true;fdV1:5  ;L1:0 ;P1:23), //wiatrakS-wirnik animowany w pierwszym obrazie,
                      (fN:'lopatySW';fAnimacja1:true;fdV1:5 ;L1:0 ;P1:23), //wiatrakSW-wirnik animowany w pierwszym obrazie,
                      (fN:'lopatySE';fAnimacja1:true;fdV1:5 ;L1:0 ;P1:23), //wiatrakSE-wirnik animowany w pierwszym obrazie,
                      (fN:'koloS'   ;fAnimacja2:true;fdV2:4 ;L2:0 ;P2:31),//oMlynS-koo animowane w drugim obrazie
                      (fN:'koloSW'  ;fAnimacja2:true;fdV2:4 ;L2:0 ;P2:31),//oMlynSW-koo animowane w drugim obrazie
                      (fN:'koloSE'  ;fAnimacja2:true;fdV2:4 ;L2:0 ;P2:31),//oMlynSE-koo animowane w drugim obrazie
                      (fAnimacja1:true;fdV1:8 ;L1:0 ;P1:15; fKolizja:true)//oKasztan1- animowany w pierwszym obrazie plus kolizja
                      );
type
 PObiektAnimacji=^TObiektAnimacji;

 TObiektAnimacji=record
      idWskMApy:byte;//id na mape warstwy
      idKafla  :LongWord;
      Animacja :tAnimacja;
 end;
 TCykl=class
    fLista:TList;
   private
    fdeltaSeconds:single;
    destructor  Destroy;virtual;
   public
    property deltaSeconds:single read fdeltaSeconds write fdeltaSeconds;
    procedure Animacja;
    procedure Dodaj(const Value:TMapa;AidWskMapy:byte;AidKafla:integer);
 end;

 procedure UstawAnimacjeWKaflu(var Value:TMapa);//proc uzupeniajaca parametry kafli wiata o animacje w czesci widocznej

var

 Cykl:TCykl;
implementation
 procedure TCykl.Animacja;
 var
   i:LongWord;
 begin
  if fLista.Count=0 then exit;
  for i:=0 to fLista.Count-1 do// downto 0 do
    with PObiektAnimacji(fLista.Items[i])^do
    begin
          //animacja pierwszego obrazu
          if DaneObiektu[Animacja.fIdObAnim].fAnimacja1 then begin
             Animacja.fAnimPos1:=Animacja.fAnimPos1+Form1.OmegaTimer1.DeltaSecs;
             if Animacja.fAnimPos1>Form1.OmegaTimer1.DeltaSecs*DaneObiektu[Animacja.fIdObAnim].fdV1 then
                begin
                inc(PMapa(Lista.Items[idWskMApy])^[IDKafla].IdKlatka,1);
                Animacja.fAnimPos1:=0;
                end;
             if PMapa(Lista.Items[idWskMApy])^[IDKafla].IdKlatka>DaneObiektu[Animacja.fIdObAnim].P1 then
                PMapa(Lista.Items[idWskMApy])^[IDKafla].IdKlatka:=DaneObiektu[Animacja.fIdObAnim].L1;
          end;
          //animacja drugiego obrazu
          if DaneObiektu[Animacja.fIdObAnim].fAnimacja2 then begin
             Animacja.fAnimPos2:=Animacja.fAnimPos2+Form1.OmegaTimer1.DeltaSecs;
             if Animacja.fAnimPos2>Form1.OmegaTimer1.DeltaSecs*DaneObiektu[Animacja.fIdObAnim].fdV2 then
                begin
                inc(PMapa(Lista.Items[idWskMApy])^[IDKafla].RGBA.idKlatka2,1);
                Animacja.fAnimPos2:=0;
                end;
             if PMapa(Lista.Items[idWskMApy])^[IDKafla].RGBA.idKlatka2>DaneObiektu[Animacja.fIdObAnim].P2 then
                PMapa(Lista.Items[idWskMApy])^[IDKafla].RGBA.idKlatka2:=DaneObiektu[Animacja.fIdObAnim].L2;
          end;

    end;
 end;
 procedure TCykl.Dodaj(const Value:TMapa;AidWskMapy:byte;AidKafla:integer);
 var
  AObiektAnimacji:PObiektAnimacji;
  jest:boolean;
 begin
  jest:=false;
  if VAlue.Name='zboze1' then
     begin
      New(AObiektAnimacji);
      AObiektAnimacji^.Animacja.fIdObAnim:=Ord(oZboze);
      jest:=true;
     end;
  if not jest then exit;
  AObiektAnimacji^.idWskMApy:=AidWskMapy;
  AObiektAnimacji^.idKafla:=AidKafla;
  fLista.Add(AObiektAnimacji);
end;

 destructor  TCykl.Destroy;
 var
   i:LongWord;
 begin
    if fLista.Count>0 then
    for i:=fLista.Count-1 downto 0 do Dispose(PObiektAnimacji(fLista.Items[i]));
    fLista.free;
 end;
//**********************************
procedure UstawAnimacjeWKaflu(var Value:TMapa);
begin
 //oWoda
 if Value.idKlatka=4 then Value.Animacja.fIdObAnim:=Ord(oWoda);

 //oWoda1
 if Value.RGBA.idKlatka2=4 then Value.Animacja.fIdObAnim :=Ord(oWoda1);
 //WiatrakS
 if Value.name='wiatrakS0' then begin
     Value.Name:=DaneObiektu[Ord(oWiatrakS)].fN;//podmien na animowany wirnik
     Value.idObrazka:=DaneMapy.OmegaImageList.ImageList.Find(Value.Name).ID;
     Value.RGBA.idobrazka2:=DaneMapy.OmegaImageList.ImageList.Find('wiatrakS').ID;//wiatrak- tylko dach- nieanimowany
     Value.RGBA.idKlatka2:=0;
     Value.RGBA.Left2:=0;
     Value.RGBA.Top2 :=-38;
     Value.Animacja.fIdObAnim:=Ord(oWiatrakS);
 end;
 //WiatrakSW
 if Value.name='wiatrakSW0' then begin
     Value.Name:=DaneObiektu[Ord(oWiatrakSW)].fN;//podmien na animowany wirnik
     Value.idObrazka:=DaneMapy.OmegaImageList.ImageList.Find(Value.Name).ID;
     Value.RGBA.idobrazka2:=DaneMapy.OmegaImageList.ImageList.Find('wiatrakSW').ID;//wiatrak- tylko dach- nieanimowany
     Value.RGBA.idKlatka2:=0;
     Value.RGBA.Left2:=0;
     Value.RGBA.Top2 :=-4;
     Value.Animacja.fIdObAnim:=Ord(oWiatrakSW);
 end;
 //WiatrakSE
 if Value.name='wiatrakSE0' then begin
     Value.Name:=DaneObiektu[Ord(oWiatrakSE)].fN;//podmien na animowany wirnik
     Value.idObrazka:=DaneMapy.OmegaImageList.ImageList.Find(Value.Name).ID;
     Value.RGBA.idobrazka2:=DaneMapy.OmegaImageList.ImageList.Find('wiatrakSE').ID;//wiatrak- tylko dach- nieanimowany
     Value.RGBA.idKlatka2:=0;
     Value.RGBA.Left2:=-26;
     Value.RGBA.Top2 :=-4;
     Value.Animacja.fIdObAnim:=Ord(oWiatrakSE);
 end;

 //MlynSW
 if Value.name='mlynSW' then begin
     Value.RGBA.idobrazka2:=DaneMapy.OmegaImageList.ImageList.Find(DaneObiektu[Ord(oMlynSW)].fN).ID;
     Value.RGBA.idKlatka2:=0;
     Value.RGBA.Left2:=24;
     Value.RGBA.Top2 :=108;
     Value.Animacja.fIdObAnim       :=Ord(oMlynSW);
 end;
 //MlynS
 if Value.name='mlynS' then begin
     Value.RGBA.idobrazka2:=DaneMapy.OmegaImageList.ImageList.Find(DaneObiektu[Ord(oMlynS)].fN).ID;
     Value.RGBA.idKlatka2:=0;
     Value.RGBA.Left2:=10;
     Value.RGBA.Top2 :=79;
     Value.Animacja.fIdObAnim       :=Ord(oMlynS);
 end;
 //kasztan1- animowany ancuch z kolczatk
 if Value.name='kasztan1' then begin
     Value.idKlatka :=Random(DaneObiektu[Ord(oKasztan1)].P2);//losuj klatk startu animacji;
     Value.Animacja.fIdObAnim       :=Ord(oKasztan1);
     Value.Animacja.fKolizja        :=DaneObiektu[Ord(oKasztan1)].fKolizja;//ustaw stan kolizji
 end;
end;
end.
