unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OmegaTimer, OmegaFont, OmegaInput, OmegaImageList, OmegaScreen,
  OmegaSprite;

type
  TKafel=class(TSprite)
    private
     ImageIndex2,
     AlphaA,
     AlphaB,
     AlphaC,
     AlphaD:integer;
     constructor Create(AParent:TOmegaSprite;
                        AOmegaImageList:TOmegaImageList;
                        AImageID,
                        AImageIndex,
                        AImageIndex2,
                        AX,AY,AZ:integer);virtual;

     procedure Draw;override;
     procedure Dide;virtual;
     procedure Collision(ASprite:TSprite);virtual;
  end;
  TWarstwa=array of array of TKafel;
  TForm1 = class(TForm)
    OmegaScreen1: TOmegaScreen;
    OmegaImageList1: TOmegaImageList;
    OmegaInput1: TOmegaInput;
    OmegaFont1: TOmegaFont;
    OmegaTimer1: TOmegaTimer;
    OmegaSprite1: TOmegaSprite;
    procedure OmegaTimer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
const
  kierunek :array[0..3,0..1] of ShortInt=((-1,-1){0},(0,-1){1},
                                          (-1, 0){2},(0, 0){3});
  kierunek1:array[0..8,0..1] of ShortInt=((-1,-1){0},(0,-1){1},( 1,-1){2},
                                          (-1, 0){3},(0, 0){4},( 1, 0){5},
                                          (-1, 1){6},(0, 1){7},( 1, 1){8});

  testRogow:array[0..3,0..2] of byte    =((0,1,3),
                                          (1,2,5),
                                          (5,7,8),
                                          (3,6,7));
  kierunek2:array[0..12,0..1]of shortInt=((0,-2),
                                  (-1,-1),(0,-1),(1,-1),
                            (-2,0),(-1,0),(0,0), (1,0),(2,0),
                                   (-1,1),(0,1),(1,1),
                                          (0,2));
  kierunek3:array[0..4,0..1]of shortInt=(
                                           (0,-1),
                                    (-1,0),(0,0),(1,0),
                                           (0,1));
  kierunekSingiel:array[0..0,0..1]of shortInt=((0,0));

var
  Form1: TForm1;
  Warstwa0,
  Warstwa1:TWarstwa;
implementation

{$R *.DFM}
procedure Odswiez(AX,AY,MaxX,MaxY,AIDTest:integer;AWarstwa:TWarstwa);
var
 w,k,
 i,Ri,Rj,
 nx,ny,
 AMax,
 Alpha: integer;
begin

for AY:=0 to MaxY do
for AX:=0 to MAxX do
{ for i:=0 to high(kierunek1)do} begin
  k :=AX;//+kierunek1[i,0];
  w :=AY;//+kierunek1[i,1];
  if (k<0)or(w<0)or(k>MaxX)or(w>MaxY)
  then continue;
  begin
    AMax:=0;
    for Rj:=0 to high(testRogow) do
     begin
      Alpha:=0;

      for Ri:=0 to high(testRogow[Rj]) do
      begin
        nx:=k+kierunek1[testRogow[Rj,Ri],0];
        ny:=w+kierunek1[testRogow[Rj,Ri],1];
        if (nx<0)or(ny<0)or(nx>MaxX)or(ny>MaxY) then continue;
        if (AWarstwa[ny,nx].ImageIndex2=AWarstwa[w,k].ImageIndex2) then inc(Alpha,255);
      end;

      if AWarstwa[w,k].ImageIndex2<>-1 then
      case Rj of
        //Rog A
        0:begin AWarstwa[w,k].AlphaA:=Round(Alpha/3);amax:=amax+alpha;end;
        //Rog B
        1:begin AWarstwa[w,k].AlphaB:=Round(Alpha/3);amax:=amax+alpha;end;
        //Rog C
        2:begin AWarstwa[w,k].AlphaC:=Round(Alpha/3);amax:=amax+alpha;end;
        //Rog D
        3:begin AWarstwa[w,k].AlphaD:=Round(Alpha/3);amax:=amax+alpha;end;
      end else break;
    end;
  end;
 end;

end;
procedure Pedzel(AX,AY,MaxX,MaxY,IDNowe:integer;AWarstwa:TWarstwa);
var
 i,
 nx,ny: integer;
begin
 for i:=0 to high(kierunek)do begin
  nx :=AX+kierunek[i,0];
  ny :=AY+kierunek[i,1];
  if (nx<0)or(ny<0)or(nx>MaxX)or(ny>MaxY)
  or(AWarstwa[ny,nx].ImageIndex2=IDNowe)
  then continue;
  AWarstwa[ny,nx].ImageIndex2:=IDNowe;
  end;
end;
procedure TKafel.Collision(ASprite:TSprite);
begin
 exit;
end;
procedure TKafel.Dide;
begin
 exit;
end;
constructor TKafel.Create(AParent:TOmegaSprite;
                          AOmegaImageList:TOmegaImageList;
                          AImageID,
                          AImageIndex,
                          AImageIndex2,
                          AX,AY,AZ:integer);
begin
 inherited Create(AParent);
 Image  :=AOmegaImageList.ImageList.Items[AImageID];
 ImageIndex:=AImageIndex;
 x:=Ax;
 y:=Ay;
 z:=AZ;
 AlphaA:=255;
 AlphaB:=255;
 AlphaC:=255;
 AlphaD:=255;
 ImageIndex2:=AImageIndex2;
 DoCollision := false;
 DoPixelcheck := false;
end;

procedure TKafel.Draw;
begin
  if ImageIndex=-1 then exit;
{  Image.Draw4Col(
                 Round(X),Round(Y),
                 Round(X+Image.TileWidth),Round(Y),
                 Round(X+Image.TileWidth),Round(Y+Image.TileHeight),
                 Round(X),Round(Y+Image.TileHeight),
                 0,0,0,1,1,
                 OmegaColor(Red,Green,Blue,255),
                 OmegaColor(Red,Green,Blue,255),
                 OmegaColor(Red,Green,Blue,255),
                 OmegaColor(Red,Green,Blue,255),
                 ImageIndex,0);}
    Image.Draw(Round(x),Round(Y),imageIndex);
 if ImageIndex2=-1 then exit;
  Image.Draw4Col(
                 Round(X),Round(Y),
                 Round(X+Image.TileWidth),Round(Y),
                 Round(X+Image.TileWidth),Round(Y+Image.TileHeight),
                 Round(X),Round(Y+Image.TileHeight),
                 0,0,0,1,1,
                 OmegaColor(Red,Green,Blue,AlphaA),
                 OmegaColor(Red,Green,Blue,AlphaB),
                 OmegaColor(Red,Green,Blue,AlphaC),
                 OmegaColor(Red,Green,Blue,AlphaD),
                 ImageIndex2,0);

end;
procedure TForm1.OmegaTimer1Timer(Sender: TObject);
begin
 OmegaInput1.Update;
 //if oisbutton1 in OmegaInput1.keyboard.statesclicked then
 // OmegaScreen1.ToggleFullScreen;
 if not omegascreen1.CanDraw then exit;
 OmegaScreen1.ClearScreen(0,0,0,0);
 OmegaScreen1.BeginRender;

 OmegaSprite1.Collision;
 OmegaSprite1.Move(OmegaTimer1.DeltaSecs);
 OmegaSprite1.Draw;
 OmegaSprite1.Dead;

 OmegaFont1.Print(0,0,'FPS: '+IntToStr(OmegaTimer1.FPS)+' Rysuj teren lewym klawiszem myszki');
 OmegaScreen1.EndRender;

end;

procedure TForm1.FormCreate(Sender: TObject);
const
  los:array[0..29]of ShortInt=(-1,-1,-1,-1,-1,2,-1,-1,-1,-1,
                               -1,-1,-1,-1,-1,-1,-1,-1,3,-1,
                               -1,-1, 1,-1,-1,-1,-1,-1,-1,-1);
var
  a,b,IdKlatkaDrzewa,
  k,w:integer;
  Drzewo:TSprite;
begin
  OmegaScreen1.Init;
  OmegaScreen1.SetHWnd(self.handle);
  OmegaFont1.Init;
  OmegaFont1.CreateFont('Arial',10,[]);
  OmegaFont1.Color:=OmegaColor(255,255,255);

  k:=24;//OmegaScreen1.Width  div OmegaImageList1.ImageList.Items[0].TileWidth;
  w:=24;//OmegaScreen1.Height div OmegaImageList1.ImageList.Items[0].TileHeight;
  setLength(Warstwa0,w+1,k+1);
  setLength(Warstwa1,w+1,k+1);
  Randomize;
  for b:=0 to w do
   for a:=0 to k do
    begin

    Warstwa0[b,a]:=TKafel.Create(OmegaSprite1,OmegaImageList1,0,-1,-1,
                                 a*OmegaImageList1.ImageList.Items[0].TileWidth,
                                 b*OmegaImageList1.ImageList.Items[0].TileHeight,0);
    Warstwa1[b,a]:=TKafel.Create(OmegaSprite1,OmegaImageList1,0,1,-1,
                                 a*OmegaImageList1.ImageList.Items[0].TileWidth,
                                 b*OmegaImageList1.ImageList.Items[0].TileHeight,1);
    IdKlatkaDrzewa:=los[Random(high(los))];
    if IdKlatkaDrzewa>-1 then begin
       Drzewo:=TSprite.Create(OmegaSprite1);
       with Drzewo do begin
         x:=a*OmegaImageList1.ImageList.Items[0].TileWidth;
         y:=b*OmegaImageList1.ImageList.Items[0].TileHeight;
         z:=2;
         Image  :=OmegaImageList1.ImageList.Items[1];
         ImageIndex:=IdKlatkaDrzewa;

       end;
    end;
    end;

end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  OmegaTimer1.Enabled:=false;
  OmegaSprite1.Dead;
  OmegaScreen1.FreeOnRelease;
  if OmegaScreen1.FullScreen then  OmegaScreen1.ToggleFullScreen;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
 OmegaTimer1.Enabled:=true;
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if key=27 then close;
end;

procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
 w,k:integer;
begin
  k:=x  div OmegaImageList1.ImageList.Items[0].TileWidth;
  w:=y  div OmegaImageList1.ImageList.Items[0].TileHeight;
  if Button=mbLeft then begin
  Pedzel (k,w,high(Warstwa1[w]),high(Warstwa1) ,3{kostka},Warstwa1);
  Odswiez(k,w,high(Warstwa1[w]),high(Warstwa1),3{kostka},Warstwa1);
  end;
  if Button=mbRight then begin
  Pedzel (k,w,high(Warstwa1[w]),high(Warstwa1) ,4{kostka},Warstwa1);
  Odswiez(k,w,high(Warstwa1[w]),high(Warstwa1),4{kostka},Warstwa1);
  end;

end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
 w,k:integer;
begin
  k:=x  div OmegaImageList1.ImageList.Items[0].TileWidth;
  w:=y  div OmegaImageList1.ImageList.Items[0].TileHeight;
  if Shift=[ssLeft] then begin
  Pedzel (k,w,high(Warstwa1[w]),high(Warstwa1) ,3{kostka},Warstwa1);
  Odswiez(k,w,high(Warstwa1[w]),high(Warstwa1),3{kostka},Warstwa1);
  end;
  if Shift=[ssRight] then begin
  Pedzel (k,w,high(Warstwa1[w]),high(Warstwa1) ,4{kostka},Warstwa1);
  Odswiez(k,w,high(Warstwa1[w]),high(Warstwa1),4{kostka},Warstwa1);
  end;

end;

end.
